/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.mixin.client.dim_stack;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackGuiController;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement;
import qouteall.imm_ptl.peripheral.ducks.IECreateWorldScreen;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.api.DimensionAPI;
import qouteall.q_misc_util.dimension.DimId;

@Mixin(value={CreateWorldScreen.class})
public abstract class MixinCreateWorldScreen
extends Screen
implements IECreateWorldScreen {
    @Shadow
    @Final
    private static Logger f_100848_;
    @Shadow
    @Final
    private WorldCreationUiState f_267389_;
    @Nullable
    private DimStackGuiController ip_dimStackController;

    protected MixinCreateWorldScreen(Component title) {
        super(title);
        throw new RuntimeException();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInitEnd(Minecraft minecraft, Screen screen, WorldCreationContext worldCreationContext, Optional<ResourceKey<WorldPreset>> optional, OptionalLong optionalLong, CallbackInfo ci) {
        DimStackManagement.dimStackToApply = DimStackManagement.getDimStackPreset();
        if (DimStackManagement.dimStackToApply != null) {
            f_100848_.info("[ImmPtl] Applying dimension stack preset");
        }
    }

    @Override
    public void ip_openDimStackScreen() {
        if (this.ip_dimStackController == null) {
            CreateWorldScreen this_ = (CreateWorldScreen)this;
            this.ip_dimStackController = new DimStackGuiController((Screen)this_, () -> this.portal_getDimensionList(), info -> {
                DimStackManagement.dimStackToApply = info;
                Minecraft.m_91087_().m_91152_((Screen)this_);
            });
            this.ip_dimStackController.initializeAsDefault();
        }
        Minecraft.m_91087_().m_91152_((Screen)this.ip_dimStackController.view);
    }

    private List<ResourceKey<Level>> portal_getDimensionList() {
        ArrayList<ResourceKey<Level>> result;
        block5: {
            Helper.log("Getting the dimension list");
            result = new ArrayList<ResourceKey<Level>>();
            try {
                WorldCreationContext settings = this.f_267389_.m_267573_();
                RegistryAccess.Frozen registryAccess = settings.m_246480_();
                WorldDimensions selectedDimensions = settings.f_243796_();
                for (Map.Entry entry : selectedDimensions.f_243948_().m_6579_()) {
                    result.add(DimId.idToKey(((ResourceKey)entry.getKey()).m_135782_()));
                }
                MappedRegistry<LevelStem> customDims = DimensionAPI.collectCustomDimensions(settings.m_246480_(), settings.f_244272_());
                for (Map.Entry entry : customDims.m_6579_()) {
                    result.add(DimId.idToKey(((ResourceKey)entry.getKey()).m_135782_()));
                }
                for (Map.Entry entry : settings.f_244375_().m_6579_()) {
                    result.add(DimId.idToKey(((ResourceKey)entry.getKey()).m_135782_()));
                }
            }
            catch (Exception e) {
                f_100848_.error("ImmPtl getting dimension list", (Throwable)e);
                if (!result.isEmpty()) break block5;
                result.add(DimId.idToKey("error:error"));
            }
        }
        return result;
    }
}

